ORCA/M Asm65816 2.1.0

0001 E6A6                       title 'MoreKidding' 
0002 E6A6              **********************************************************************
0003 E6A6              *
0004 E6A6              * MoreKidding.ASM
0005 E6A6              *
0006 E6A6              * Copyright Apple Computer, Inc. 1988
0007 E6A6              * All Rights Reserved
0008 E6A6              *
0009 E6A6              * By Steven Glass
0010 E6A6              *
0011 E6A6              * This is a file that contains code simulate the stack entry point
0012 E6A6              * in the early versions of the OS that did not have one.
0013 E6A6              *
0014 E6A6              * This code has two parts, the first installs a jml at the stack
0015 E6A6              * entry point for the OS.  It is run at tool init time.
0016 E6A6              *
0017 E6A6              * The second is the code that is entered by the jump.
0018 E6A6              *
0019 E6A6              *
0020 E6A6              **********************************************************************
0021 E6A6                       blanks off 
0022 E6A6                       include 'all.macros' 
0023 E6A6
0024 E6A6              OS_Kind  equ   $E100BC
0025 E6A6              OS_Boot  equ   $E100BD
0026 E6A6              OS_Flag  equ   $E100BE
0027 E6A6
0028 E6A6              OS_StackEntry equ   $E100B0
0029 E6A6
0030 E6A6              drvr_dib_ptr equ   $00BD24
0031 E6A6
0032 E6A6
0033 E6A6              ****************************************************************
0034 E6A6              *
0035 E6A6              FixOSStackEntry PROC EXPORT 
0036 E6A6              *
0037 E6A6              * Description
0038 E6A6              *
0039 E6A6              *
0040 E6A6              * Inputs:
0041 E6A6              *                   none
0042 E6A6              *
0043 E6A6              * Outputs:
0044 E6A6              *                   none
0045 E6A6              *
0046 E6A6              * External Refs:
0047 E6A6                       import FakeStackEntry 
0048 E6A6              *
0049 E6A6              * Entry Points:
0050 E6A6              *                   none
0051 E6A6              *
0052 E6A6                       longa on                       ; mode
0053 E6A6                       longi on
0054 E6A6              *
0055 E6A6              ****************************************************************
0056 E6A6
0057 E6A6
0058 E6A6 AF B7 E6 FC           lda   >MyJump
0059 E6AA 8F B0 00 E1           sta   >OS_StackEntry
0060 E6AE AF B9 E6 FC           lda   >MyJump+2
0061 E6B2 8F B2 00 E1           sta   >OS_StackEntry+2
0062 E6B6
0063 E6B6 6B                    rtl   
0064 E6B7
0065 E6B7 5C BB E6 FC  MyJump   jml   FakeStackEntry
0066 E6BB
0067 E6BB                       ENDP 
0068 E6BB
0069 E6BB
0070 E6BB
0071 E6BB              ****************************************************************
0072 E6BB              *
0073 E6BB              FakeStackEntry PROC 
0074 E6BB              *
0075 E6BB              * This is the code that is run when someone calls the OS
0076 E6BB              * stack entry point and the OS is not in place.
0077 E6BB              *
0078 E6BB              * The way this code works is to generate an inline OS call
0079 E6BB              * on the stack.  the code is called with the equivalent to 
0080 E6BB              * a JSL and when it returns, the stack is cleaned up and
0081 E6BB              * control returns to the calling routine just as if the 
0082 E6BB              * stack entry point existed.
0083 E6BB              *
0084 E6BB              *
0085 E6BB              * Inputs:
0086 E6BB              *                   LONG : ParamBlockPtr
0087 E6BB              *                   WORD : CallNumber
0088 E6BB              *
0089 E6BB              * Outputs:
0090 E6BB              *                   a-reg : error code
0091 E6BB              *                   carry : error state
0092 E6BB              *                   z-flag : error state
0093 E6BB              *
0094 E6BB              * External Refs:
0095 E6BB              *                   none
0096 E6BB              *
0097 E6BB              * Entry Points:
0098 E6BB              *                   none
0099 E6BB              *
0100 E6BB                       longa on                       ; mode
0101 E6BB                       longi on
0102 E6BB              *
0103 E6BB              ****************************************************************
0104 E6BB
0105 E6BB                       DefineStack 
0106 E6BB              TheJSL   LONG 
0107 E6BB              TheCall  word 
0108 E6BB              ThePtr   long 
0109 E6BB              TheRTL   word 
0110 E6BB              RTLAdr   block 3
0111 E6BB              inCallNumber word 
0112 E6BB              inParamPtr long 
0113 E6BB
0114 E6BB              ;
0115 E6BB              ; Push the code to call the OS on the stack.
0116 E6BB              ;
0117 E6BB A2 0A 00              ldx   #BytesToPush-2
0118 E6BE BF F5 E6 FC  PushMore lda   >TheCode,x
0119 E6C2 48                    pha   
0120 E6C3 CA                    dex   
0121 E6C4 CA                    dex   
0122 E6C5 10 F7                 bpl   PushMore
0123 E6C7
0124 E6C7              ;
0125 E6C7              ; copy the inputs from the stack into the code block (also on the stack)
0126 E6C7              ;
0127 E6C7 A3 10                 lda   inCallNumber,s
0128 E6C9 83 05                 sta   TheCall,s
0129 E6CB A3 12                 lda   inParamPtr,s
0130 E6CD 83 07                 sta   ThePtr,s
0131 E6CF A3 14                 lda   inParamPtr+2,s
0132 E6D1 83 09                 sta   ThePtr+2,s
0133 E6D3
0134 E6D3              ;
0135 E6D3              ; Move the real RTL address up so we can easily strip the inputs
0136 E6D3              ; off the stack later.
0137 E6D3              ;
0138 E6D3 A3 0D                 lda   RTLAdr,s
0139 E6D5 83 13                 sta   RTLAdr+6,s
0140 E6D7 A3 0E                 lda   RTLAdr+1,s
0141 E6D9 83 14                 sta   RTLAdr+6+1,s
0142 E6DB
0143 E6DB              ;
0144 E6DB              ; Make the OS call using the code now on the stack.  Note the
0145 E6DB              ; code starts at S+1 on the stack.  But since the RTL adds
0146 E6DB              ; 1 to the address before xfering control, we can use it
0147 E6DB              ; as is.
0148 E6DB              ;
0149 E6DB 3B                    tsc   
0150 E6DC 22 EE E6 FC           jsl   CallIt
0151 E6E0
0152 E6E0 A8                    tay                            ; save error code in y
0153 E6E1
0154 E6E1              ;
0155 E6E1              ; Pull the code and the inputs off the stack
0156 E6E1              ;
0157 E6E1 A2 10 00              ldx   #BytesToPush-2+6
0158 E6E4 68           PullMore pla   
0159 E6E5 CA                    dex   
0160 E6E6 CA                    dex   
0161 E6E7 10 FB                 bpl   PullMore
0162 E6E9
0163 E6E9 98                    tya                            restore carry and a-reg
0164 E6EA C9 01 00              cmp   #1
0165 E6ED 6B                    rtl   
0166 E6EE
0167 E6EE              ;
0168 E6EE              ; Xfer control to the place on the stack indicated by the a-reg
0169 E6EE              ;
0170 E6EE F4 00 00     CallIt   pea   0000                     ; push 3 bytes on stack with highest = 0
0171 E6F1 8B                    phb   
0172 E6F2 83 01                 sta   1,s                      ; overstore low 2 and xfer
0173 E6F4 6B                    rtl   
0174 E6F5
0175 E6F5
0176 E6F5
0177 E6F5
0178 E6F5              TheCode   
0179 E6F5 22 A8 00 E1           jsl   $E100A8
0180 E6F9 00 00                 DC W:0
0181 E6FB 00 00 00 00           DC L:0
0182 E6FF 6B                    rtl   
0183 E700 00                    DC B:0                         ; extra byte to make it even
0184 E701
0185 E701              BytesToPush equ   *-TheCode
0186 E701
0187 E701
0188 E701                       ENDP 
0189 E701
0190 E701
0191 E701                       END   
